<?php
// +----------------------------------------------------------------------
// | 月梦网络软件系统 [ DM299 ]
// +----------------------------------------------------------------------
// | 版权所有 2021~2025 月梦网络 [ http://www.dm299.com ]
// +----------------------------------------------------------------------
// | 官方网站：http://dm299.com
// +----------------------------------------------------------------------
// | 开源协议 ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | 作者: 周志华 <124861234@qq.com>
// +----------------------------------------------------------------------

namespace plugins\Sysinfo;

use \Base\Plugin;

/**
 * 系统环境信息插件
 * @package plugins\SystemInfo
 * @author 周志华 <124861234@qq.com>
 */
class Sysinfo extends Plugin
{
    /**
     * @var array 插件信息
     */
    public $info = [
        // 插件名[必填]
        'name'        => 'Sysinfo',
        // 插件标题[必填]
        'title'       => '系统环境信息',
        // 插件唯一标识[必填],格式：插件名.开发者标识.plugin
        'identifier'  => 'system_info.ming.plugin',
        // 插件图标[选填]
        'icon'        => 'fa fa-fw fa-info-circle',
        // 插件描述[选填]
        'description' => '在后台首页显示服务器信息',
        // 插件作者[必填]
        'author'      => '周志华',
        // 作者主页[选填]
        'author_url'  => 'http://www.dm299.com',
        // 插件版本[必填],格式采用三段式：主版本号.次版本号.修订版本号
        'version'     => '1.0.0',
        // 是否有后台管理功能[选填]
        'admin'       => '0',
    ];

    /**
     * @var array 插件钩子
     */
    public $hooks = [
        ['name'=>'admin_index','description'=>'后台首页']
    ];

    /**
     * 后台首页钩子
	 * @author 周志华 <124861234@qq.com>
     */
    public function adminIndex()
    {
		$sys_info['os']				= PHP_OS;
		$sys_info['ip']				= $_SERVER['SERVER_ADDR'];
		$sys_info['php_ver']		= PHP_VERSION;
		$sys_info['mysql_ver']		= \Base\Core::$db->version();
		$sys_info['web_server']		= $_SERVER['SERVER_SOFTWARE'];
		$sys_info['max_filesize']	= ini_get('upload_max_filesize');
		$sys_info['disk_place']		= function_exists('disk_free_space') ? floor(disk_free_space(APP_PATH) / (1024*1024)) : 0;
		$sys_info['app_version']	= APP_VERSION;
		$sys_info['php_mod']		= php_sapi_name();
		$sys_info['max_time']		=ini_get("max_execution_time");
		$this->assign('sys_info', $sys_info);
		echo $this->fetch('widget');
    }

    /**
     * 安装方法
	 * @author 周志华 <124861234@qq.com>
     * @return bool
     */
    public function install(){
        return true;
    }

    /**
     * 卸载方法必
	 * @author 周志华 <124861234@qq.com>
     * @return bool
     */
    public function uninstall(){
        return true;
    }
}