<?php
// +----------------------------------------------------------------------
// | 月梦网络软件系统 [ DM299 ]
// +----------------------------------------------------------------------
// | 版权所有 2021~2025 月梦网络 [ http://www.dm299.com ]
// +----------------------------------------------------------------------
// | 官方网站：http://dm299.com
// +----------------------------------------------------------------------
// | 开源协议 ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | 作者: 周志华 <124861234@qq.com>
// +----------------------------------------------------------------------

namespace plugins\Hello;

use \Base\Plugin;

/**
 * 演示插件
 * @package plugin\HelloWorld
 * @author 周志华 <124861234@qq.com>
 */
class Hello extends Plugin
{
    /**
     * @var array 插件信息
     */
    public $info = [
        // 插件名[必填]
        'name'        => 'Hello',
        // 插件标题[必填]
        'title'       => '你好，世界',
        // 插件唯一标识[必填],格式：插件名.开发者标识.plugin
        'identifier'  => 'helloworld.ming.plugin',
        // 插件图标[选填]
        'icon'        => 'fa fa-fw fa-globe',
        // 插件描述[选填]
        'description' => '这是一个演示插件，会在每个页面生成一个提示“Hello World”。您可以查看源码，里面包含了绝大部分插件所用到的方法，以及能做的事情。',
        // 插件作者[必填]
        'author'      => '周志华',
        // 作者主页[选填]
        'author_url'  => 'http://www.dm299.com',
        // 插件版本[必填],格式采用三段式：主版本号.次版本号.修订版本号
        'version'     => '1.0.0',
        // 是否有后台管理功能
        'admin'       => '1',
    ];

    /**
     * @var string 原数据库表前缀
     * 用于在导入插件sql时，将原有的表前缀转换成系统的表前缀
     * 一般插件自带sql文件时才需要配置
     */
    public $database_prefix = 'dm_';

    /**
     * @var array 插件钩子
     */
    public $hooks = [
        ['name'=>'page_tips','description'=>'我的钩子']
    ];

    /**
     * page_tips钩子方法
     * @param $params
     * @author 周志华 <124861234@qq.com>
     */
    public function pageTips(&$params)
    {
		if( !(\Base\Router::chk('admin/index/index')) ) {
			echo '<div class="layui-fluid" style="padding-bottom:0;">
					<blockquote class="layui-card layui-elem-quote">Hello World</blockquote>
				</div>';
		}
    }



    /**
     * 安装方法必须实现
     * 一般只需返回true即可
     * 如果安装前有需要实现一些业务，可在此方法实现
     * @author 周志华 <124861234@qq.com>
     * @return bool
     */
    public function install(){
        return true;
    }

    /**
     * 卸载方法必须实现
     * 一般只需返回true即可
     * 如果安装前有需要实现一些业务，可在此方法实现
     * @author 周志华 <124861234@qq.com>
     * @return bool
     */
    public function uninstall(){
        return true;
    }
}
